/**
* Game Javascript API and platform specific handlers
*/
function get_gameApi()
{
	return gameApi;
}

var gameApi =
{
	onOrientationChange:null,
	
	ipadVersion:0,

	gameSize: {
		width:853,
		height:480
	},
	
	widthToHeight:0,
	
	pathToAssets: "",
	
	gameResizeFunc:null,
	
	isFirstOrientationCheck:true,
	isReversedOrientation:false,
	
	init:function()
	{		
		//Set the right orientation pop-up image
		if(navigator.userAgent.match(/iPhone|iPod|Android/i))
		{
			//document.getElementById("imgPortraitWarning").src = "assets/popup_landscape/orientation_iphone.png";
		}
	},
  
	/* Portrait mode warning, called from com.bkom.core.views.AbstractViewManager.update() */
	showPortraitWarning:function(isReversed)
	{		
		if (isReversed)
		{
			document.getElementById('portrait').style.cssText="display: block; z-index:10000;width:"+window.innerWidth+"px;height:"+window.innerHeight+"px;";
			//calculate the scale
			var scale = Math.min(window.innerWidth/350, window.innerHeight/337, 1);
			document.getElementById('imgPortraitWarning').style.cssText="-webkit-transform: rotate(90deg) scale("+scale+"); transform: rotate(90deg); scale("+scale+");";
		}else{
			document.getElementById('portrait').style.cssText="display: block; z-index:10000;width:"+window.innerWidth+"px;height:"+window.innerHeight+"px;";
			//calculate the scale
			var scale = Math.min(350/window.innerWidth, 337/window.innerHeight);
			document.getElementById('imgPortraitWarning').style.cssText="-webkit-transform: translate(-100px,0px) rotate(180deg) scale("+scale+"); transform: translate(-100px,0px) rotate(180deg); scale("+scale+");";
		}
	},
	
	hidePortraitWarning:function()
	{
		document.getElementById('portrait').style.cssText="display:none;z-index:-1;";		
	},	

	// ::: GET COOKIE :::
	getCookie:function(name) 
	{
		var value = document.cookie;
		var start = value.indexOf(" " + name + "=");
		if (start == -1) {
			start = value.indexOf(name + "=");
		}
		
		if (start == -1) {
			value = null;
		} else {
			start = value.indexOf("=", start) + 1;
			var end = value.indexOf(";", start);
			if (end == -1) {
				end = value.length;
			}
			value = unescape(value.substring(start,end));
		}
		return value;
	},
	
	// ::: SET COOKIE :::
	setCookie:function(name, value, exdays) 
	{
		var exdate 		= new Date();
		exdate.setDate(exdate.getDate() + exdays);
		var value 		= escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
		document.cookie = name + "=" + value;
	},
	
	// ::: DOM PURGE :::
	// http://javascript.crockford.com/memory/leak.html
	// cleans dom element to prevent memory leaks
	domPurge:function(d) 
	{
	    var a = d.attributes, i, l, n;
	    if (a) {
	        for (i = a.length - 1; i >= 0; i -= 1) {
	            n = a[i].name;
	            if (typeof d[n] === 'function') {
	                d[n] = null;
	            }
	        }
	    }
	    a = d.childNodes;
	    if (a) {
	        l = a.length;
	        for (i = 0; i < l; i += 1) {
	            domPurge(d.childNodes[i]);
	       }
	    }
	},

	// ::: DOM REMOVE :::
	domRemove:function(id) 
	{
	    var elem = document.getElementById(id);
	    domPurge(elem);
	    return elem.parentNode.removeChild(elem);
	},
	
	// ::: IS IOS 5 :::
	isIos5:function()
	{
		if(/OS [5]_\d(_\d)? like Mac OS X/i.test(navigator.userAgent)) 
		{  
			//alert("Using API to play sounds");
			return true;
		}
		else
		{
			//alert("Using Flambe to play sounds");
			return false;
		}
	},
	
	// ::: GET CURRENTLOCALE :::
	getCurrentLocale:function()
	{
		return document.documentElement.lang.replace("-","_");
	},
	
	// ::: OPEN PAGE :::
	openPage:function(url)
	{		
		var win=window.open(url,"_self");
		if (win)
		{
			win.focus();
		}
	}
};

var isFixed = false;
var firstOrientationCheckDone = false;
var firstOrientation = "";

gameApi.widthToHeight = (gameApi.gameSize.width / gameApi.gameSize.height);

function getUserName()
{
	if (parent && parent.ark && parent.ark.User.getUser())
	{
		return parent.ark.User.getUser().username;
	}else{
		var cookie = gameApi.getCookie("nerf_account");
		if (cookie)
			return JSON.parse(cookie).username;
	}
	return "";
}

function getSessionId()
{
	if (parent && parent.ark && parent.ark.User.getUser())
	{
		return parent.ark.User.getUser().sessionId;
	}else{
		var cookie = gameApi.getCookie("nerf_account");
		if (cookie)
			return JSON.parse(cookie).sessionId;
	}
	return "";
}

function getCurrentLocale()
{
	var loc = document.documentElement.lang;
	if (!(loc && loc.length >= 5))
	{
		loc = getUrlParameters("locale","",false);
		if (!(loc && loc.length >= 5))
		{
			loc = "en-US";
		}
	}
	var locale = loc.replace("_","-");
	return locale;
}

function getCurrentLocaleUnderscore()
{
	return getCurrentLocale().replace("-","_");
}

function getUrlParameters(parameter, staticURL, decode)
{
	/*
		Function: getUrlParameters
		Description: Get the value of URL parameters either from 
		current URL or static URL
		Author: Tirumal
		URL: www.code-tricks.com
	*/
	
	var currLocation = (staticURL.length)? staticURL : window.location.search;
	var parArr = currLocation.split("?");
	var returnBool = true;

	if (parArr.length > 1)
	{
		parArr = parArr[1].split("&");
	}else{
		return -1;
	}

	for(var i = 0; i < parArr.length; i++)
	{
		parr = parArr[i].split("=");
		if(parr[0] == parameter){
			returnBool = true;
			return (decode) ? decodeURIComponent(parr[1]) : parr[1];			
		}else{
			returnBool = false;            
		}
	}

	if(!returnBool) return -1;
}

function copyJsonObject(object)
{
	return jQuery.extend(true, {}, object);
}

function displayGame()
{
	var gameCanvas = document.getElementById('gameCanvas');
	gameCanvas.style.display = "";
}

function isInIframe () 
{
	try {
		return window.self !== window.top;
	} catch (e) {
		return true;
	}
}

var userOS = "";    // will either be iOS, Android or unknown
var userOSver = 0; // this is a string, use Number(userOSver) to convert

function getIosVersion( )
{
  var ua = navigator.userAgent;
  var uaindex;

  // determine OS
  if ( ua.match(/iPhone/i) )
  {
    userOS = 'iOS';
    uaindex = ua.indexOf( 'OS ' );
  }

  // determine version
  if ( userOS === 'iOS'  &&  uaindex > -1 )
  {
    userOSver = ua.substr( uaindex + 3, 3 ).replace( '_', '.' );
  }
  
  return userOSver;
}

var xmlSerializer = new XMLSerializer();
function getSvgXmlBase64(svgElement)
{
	if (xmlSerializer == null) xmlSerializer = new XMLSerializer();	
	return 'data:image/svg+xml;base64,'+window.btoa(xmlSerializer.serializeToString(svgElement));
}

function isIe9()
{
	var browser = {};
	if (/(MSIE\ [0-9]{1})/i.test(navigator.userAgent)) {
					browser.agent = navigator.userAgent.match(/(MSIE\ [0-9]{1})/i)[0].split(" ")[0];
					browser.version  = parseInt(navigator.userAgent.match(/(MSIE\ [0-9]{1})/i)[0].split(" ")[1]);
	}
	if (browser.agent == "MSIE" && browser.version == 9) return true;

	return false;
}
